#version 330
#extension GL_EXT_gpu_shader4 : enable
//Cubic Shell with SlitsMod01.fsh  by   Kamoshika
//https://www.shadertoy.com/view/ftj3WG
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// https://twitter.com/kamoshika_vrc/status/1362976717350924290
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 p = (gl_FragCoord.xy * 2. - iResolution.xy) / min(iResolution.x, iResolution.y);
    vec3 rayPos = vec3(0, 0, 2);
    vec3 col = vec3(0);
    float d, a, e;
    float c = 0.;
    
    for(float i = 0.;i < 99.;i++){
        e = length(max(abs(rayPos) - .5, 0.)) - .1;
        a = acos(rayPos.y / length(rayPos)) * 5. + sign(rayPos.z) * acos(rayPos.x / length(rayPos.zx));
        a += iTime * 3.;
        d = max(abs(e) - .05, sin(a * 3.) * .01);
        if(d < 1e-4){
            break;
        }
        rayPos += normalize(vec3(p, -2)) * d;
        c++;
    }
    
    if(e < 0.){
        col = vec3(1., 1., 0.);
    }else if(e < 0.3){
        col = vec3(0., 0., 1.);
    }
    
    gl_FragColor = vec4(col * 30. / c, 1.);
    gl_FragColor.a = (length(gl_FragColor.rgb)*0.96);
}